/**
* \file: Authenticator.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: D. Girnus / ADIT/SW2 / dgirnus@de.adit-jv.com
*
* \copyright (c) 2015 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include "aauto/AautoLogging.h"
#include <aauto/util/Log.h>

#include <adit_logging.h>
#include <cstdarg>

/* @brief DLT context for all ADIT AndroidAuto components.
 * */
#define DLT_CTXT_AAUTO_RECEIVER                 "RECV"
#define DLT_CTXT_AAUTO_TRANSPORT                "TRNS"
#define DLT_CTXT_AAUTO_AUTHENTICATION           "AUTH"
#define DLT_CTXT_AAUTO_COMMON                   "COMM"

/* @brief DLT context description for all ADIT AndroidAuto components.
 * */
#define DLT_CTXT_DESC_AAUTO_RECEIVER            "AAUTO receiver"
#define DLT_CTXT_DESC_AAUTO_TRANSPORT           "AAUTO transport"
#define DLT_CTXT_DESC_AAUTO_AUTHENTICATION      "AAUTO authentication"
#define DLT_CTXT_DESC_AAUTO_COMMON              "AAUTO common"

/* @brief Declare the DLT context for all ADIT AndroidAuto components.
 * */
LOG_DECLARE_CONTEXT(aauto_receiver)
LOG_DECLARE_CONTEXT(aauto_transport)
LOG_DECLARE_CONTEXT(aauto_authentication)
LOG_DECLARE_CONTEXT(aauto_common)

void aautoRegisterAppWithDLT(const char* ApplnID, const char* ApplnDesc)
{
    /* register Application with DLT */
    LOG_REGISTER_APP(ApplnID, ApplnDesc);
}

void aautoDeRegisterAppWithDLT(void)
{
    /* unregister Application */
    LOG_UNREGISTER_APP();
}

void aautoRegisterCtxtWithDLT(void)
{
    /* register contexts */
    LOG_REGISTER_CONTEXT(aauto_receiver,          DLT_CTXT_AAUTO_RECEIVER,        DLT_CTXT_DESC_AAUTO_RECEIVER);
    LOG_REGISTER_CONTEXT(aauto_transport,         DLT_CTXT_AAUTO_TRANSPORT,       DLT_CTXT_DESC_AAUTO_TRANSPORT);
    LOG_REGISTER_CONTEXT(aauto_authentication,    DLT_CTXT_AAUTO_AUTHENTICATION,  DLT_CTXT_DESC_AAUTO_AUTHENTICATION);
    LOG_REGISTER_CONTEXT(aauto_common,            DLT_CTXT_AAUTO_COMMON,          DLT_CTXT_DESC_AAUTO_COMMON);

    set_aauto_log_fn(aautoLog);
}

void aautoDeRegisterCtxtWithDLT(void)
{
    /* unregister contexts */
    LOG_UNREGISTER_CONTEXT(aauto_receiver);
    LOG_UNREGISTER_CONTEXT(aauto_transport);
    LOG_UNREGISTER_CONTEXT(aauto_authentication);
    LOG_UNREGISTER_CONTEXT(aauto_common);
}

int aautoLog(int log_level, va_list args) {

    const char* formatString = va_arg(args, char*);

    char buffer[2048];
    vsnprintf(buffer, 2048, formatString, args);
    switch(log_level){
    case 1:
        LOG_ERROR((aauto_receiver, "%s", buffer));
        break;
    case 2:
        LOG_WARN((aauto_receiver, "%s", buffer));
        break;
    case 3:
        LOG_INFO((aauto_receiver, "%s", buffer));
        break;
    case 4:
        LOGD_DEBUG((aauto_receiver, "%s", buffer));
        break;
    default:
        break;
    }

    return 1;
}
